﻿namespace Hims.Shared.UserModels.Scan.ScanClassification
{
    using Hims.Shared.Dapper.Attributes;
    using System;
    using System.ComponentModel.DataAnnotations;

    /// <summary>
    /// The Id Proof Identifier
    /// </summary>
#pragma warning disable S101 // Types should be named in PascalCase
    public class FetchModel
#pragma warning restore S101 // Types should be named in PascalCase
    {
        /// <summary>
        /// Gets or sets the scan classification id.
        /// </summary>
        /// <value>
        /// The Id proof identifier.
        /// </value>
        public int ScanClassificationId { get; set; }

        /// <summary>
        /// Gets or sets the name of the scan classification.
        /// </summary>
        /// <value>
        /// The name of the scan classification.
        /// </value>
        public string ScanClassificationName { get; set; } 
        
        /// <summary>
        /// Gets or sets the name of the modify name.
        /// </summary>
        /// <value>
        /// The name of the modify name.
        /// </value>
        public string ModifiedByName { get; set; }
        
        /// <summary>
        /// Gets or sets the name of the created by name.
        /// </summary>
        /// <value>
        /// The name of the modify name.
        /// </value>
        public string CreatedByName { get; set; }



        /// <summary>
        /// Gets or sets a value indicating whether this <see cref="ScanClassification"/> is active.
        /// </summary>
        /// <value>
        ///   <c>true</c> if active; otherwise, <c>false</c>.
        /// </value>
        public bool? Active { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        /// <value>
        /// The created by.
        /// </value>
        public int CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        /// <value>
        /// The created date.
        /// </value>
        public DateTime CreatedDate { get; set; }

        /// <summary>
        /// Gets or sets the modified by.
        /// </summary>
        /// <value>
        /// The modified by.
        /// </value>
        public int? ModifiedBy { get; set; }

        /// <summary>
        /// Gets or sets the modified date.
        /// </summary>
        /// <value>
        /// The modified date.
        /// </value>
        public DateTime? ModifiedDate { get; set; }

        /// <summary>
        /// Gets or sets the page index.
        /// </summary>
        public int PageIndex { get; set; }

        /// <summary>
        /// Gets or sets the page size.
        /// </summary>
        public int PageSize { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether active.
        /// </summary>
        public int TotalItems { get; set; }
    }
}
